clear all
close all

shl = load('..\Input Data\Shorelines\1970-1988_shoreline\1970-1988_scatter.xy');

x1 = shl(:,1); y1 = shl(:,2);

% To cut-out portion of the shoreline

% west_lim = [705963.5236,10650.4778];
% east_lim = [835769.8324,95184.8619];
% ind = find(x1>=west_lim(1)& x1<=east_lim(1));
% xs1 = x1(ind); 
% ys1 = y1(ind);
% dist = xs1*0;
% for k=1:length(dist)-1
%    dist(k+1) = sqrt((xs1(k+1)-xs1(k))^2 + (ys1(k+1)-ys1(k))^2);    
% end

% Transform shoreline to regularly spaced points

nb = 1000; % number of points

dist = x1*0;
for k=1:length(dist)-1
   dist(k+1) = sqrt((x1(k+1)-x1(k))^2 + (y1(k+1)-y1(k))^2);    
end
dist = cumsum(dist);
dist2 = linspace(0,dist(end),nb);
x2 = interp1(dist,x1,dist2);
y2 = interp1(dist,y1,dist2);


plot(x1,y1,'.-b')
hold on
plot(x2,y2,'.-r')


% Smooth shoreline 
n = 10;  %n = window size (larger -> smoother)
c = ones(n,1)/n;
xs2 = filtfilt(c,1,x2);
ys2 = filtfilt(c,1,y2);

plot(xs2,ys2,'.-g')
axis equal

% save smoothed shoreline in ascii file 
ind =1;
saveascii('..\Input Data\Shorelines\1970_initial_Onslow_interp.xy',[x2(1:ind:end)',y2(1:ind:end)'])





return
n = 30;
c = ones(n,1)/n;
xs3 = filtfilt(c,1,x2);
ys3 = filtfilt(c,1,y2);

plot(xs3,ys3,'.-m')





